// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Webscript.pas' rev: 10.00

#ifndef WebscriptHPP
#define WebscriptHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Sysutils.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Contnrs.hpp>	// Pascal unit
#include <Httpapp.hpp>	// Pascal unit
#include <Httpprod.hpp>	// Pascal unit
#include <Websnapobjs.hpp>	// Pascal unit
#include <Sitecomp.hpp>	// Pascal unit
#include <Webcntxt.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Webscript
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS EScriptEvalError;
class PASCALIMPLEMENTATION EScriptEvalError : public Httpapp::EWebBrokerException 
{
	typedef Httpapp::EWebBrokerException inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall EScriptEvalError(const AnsiString Msg) : Httpapp::EWebBrokerException(Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EScriptEvalError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : Httpapp::EWebBrokerException(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EScriptEvalError(int Ident)/* overload */ : Httpapp::EWebBrokerException(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EScriptEvalError(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : Httpapp::EWebBrokerException(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EScriptEvalError(const AnsiString Msg, int AHelpContext) : Httpapp::EWebBrokerException(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EScriptEvalError(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : Httpapp::EWebBrokerException(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EScriptEvalError(int Ident, int AHelpContext)/* overload */ : Httpapp::EWebBrokerException(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EScriptEvalError(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : Httpapp::EWebBrokerException(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EScriptEvalError(void) { }
	#pragma option pop
	
};


class DELPHICLASS ERecursiveIncludeFile;
class PASCALIMPLEMENTATION ERecursiveIncludeFile : public Httpprod::EScriptError 
{
	typedef Httpprod::EScriptError inherited;
	
public:
	#pragma option push -w-inl
	/* EScriptError.Create */ inline __fastcall ERecursiveIncludeFile(const Httpprod::TAbstractScriptErrors* AErrors, const AnsiString AContent) : Httpprod::EScriptError(AErrors, AContent) { }
	#pragma option pop
	#pragma option push -w-inl
	/* EScriptError.Destroy */ inline __fastcall virtual ~ERecursiveIncludeFile(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall ERecursiveIncludeFile(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : Httpprod::EScriptError(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall ERecursiveIncludeFile(int Ident)/* overload */ : Httpprod::EScriptError(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall ERecursiveIncludeFile(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : Httpprod::EScriptError(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall ERecursiveIncludeFile(const AnsiString Msg, int AHelpContext) : Httpprod::EScriptError(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall ERecursiveIncludeFile(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : Httpprod::EScriptError(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall ERecursiveIncludeFile(int Ident, int AHelpContext)/* overload */ : Httpprod::EScriptError(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall ERecursiveIncludeFile(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : Httpprod::EScriptError(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
};


class DELPHICLASS TScriptFile;
class DELPHICLASS TScriptProducer;
class DELPHICLASS THTMLItems;
class DELPHICLASS THTMLItem;
class PASCALIMPLEMENTATION THTMLItems : public Contnrs::TObjectList 
{
	typedef Contnrs::TObjectList inherited;
	
public:
	THTMLItem* operator[](int Index) { return Items[Index]; }
	
private:
	Classes::TMemoryStream* FStream;
	char *FBuffer;
	TScriptProducer* FProducer;
	
public:
	__fastcall THTMLItems(TScriptProducer* AProducer);
	__fastcall virtual ~THTMLItems(void);
	void __fastcall Prepare(void);
	AnsiString __fastcall MakeIdentifier(THTMLItem* AItem);
	THTMLItem* __fastcall GetHTMLItem(int I);
	__property THTMLItem* Items[int Index] = {read=GetHTMLItem/*, default*/};
};


class DELPHICLASS TScriptIncludeFiles;
class DELPHICLASS TScriptIncludeFile;
class PASCALIMPLEMENTATION TScriptIncludeFiles : public Contnrs::TObjectList 
{
	typedef Contnrs::TObjectList inherited;
	
public:
	TScriptIncludeFile* operator[](int Index) { return Items[Index]; }
	
private:
	TScriptProducer* FProducer;
	
public:
	__fastcall TScriptIncludeFiles(TScriptProducer* AProducer);
	TScriptIncludeFile* __fastcall GetScriptIncludeFile(int I);
	__property TScriptIncludeFile* Items[int Index] = {read=GetScriptIncludeFile/*, default*/};
public:
	#pragma option push -w-inl
	/* TList.Destroy */ inline __fastcall virtual ~TScriptIncludeFiles(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TScriptProducer : public Httpprod::TAbstractScriptProducer 
{
	typedef Httpprod::TAbstractScriptProducer inherited;
	
private:
	bool FDesigning;
	THTMLItems* FHTMLItems;
	TScriptIncludeFiles* FIncludeFiles;
	System::TObject* FWebModuleContext;
	bool FStripParamQuotes;
	Httpprod::THandleTagProc FHandleTag;
	Classes::TMemoryStream* FContent;
	Httpprod::_di_ILocateFileService FLocateFileService;
	THTMLItem* __fastcall GetHTMLItem(int I);
	int __fastcall GetHTMLItemCount(void);
	AnsiString __fastcall GetScript();
	Classes::TComponent* __fastcall GetComponent(void);
	void __fastcall WritePChar(const char * AValue, int ALength);
	
protected:
	TScriptFile* FScriptFile;
	AnsiString FScriptEngine;
	Httpprod::TAbstractScriptErrors* FErrors;
	virtual AnsiString __fastcall EvaluateExpression(TScriptFile* AScriptFile) = 0 ;
	virtual HRESULT __fastcall ImplHandleScriptError(const System::_di_IInterface ScriptError) = 0 ;
	System::TObject* __fastcall GetWebModuleContext(void);
	AnsiString __fastcall GetHTMLBlock(int I);
	int __fastcall GetHTMLBlockCount(void);
	Httpprod::TAbstractScriptErrors* __fastcall GetErrors(void);
	void __fastcall ParseStream(Classes::TStream* Stream, bool Owned);
	void __fastcall ParseString(const AnsiString S);
	AnsiString __fastcall ReplaceTags(const AnsiString AValue);
	AnsiString __fastcall Evaluate();
	void __fastcall HandleParserError(Sysutils::Exception* E);
	void __fastcall Write(const WideChar * AValue, int ALength)/* overload */;
	void __fastcall Write(const AnsiString Value)/* overload */;
	void __fastcall Write(char * Value)/* overload */;
	AnsiString __fastcall GetContent();
	void __fastcall SetContent(const AnsiString Value);
	void __fastcall WriteItem(int Index);
	HRESULT __fastcall HandleScriptError(const System::_di_IInterface ScriptError);
	__property AnsiString Script = {read=GetScript};
	__property Httpprod::TAbstractScriptErrors* Errors = {read=FErrors};
	__property bool Designing = {read=FDesigning, nodefault};
	__property Classes::TComponent* Component = {read=GetComponent};
	__property AnsiString Content = {read=GetContent};
	
public:
	__fastcall virtual TScriptProducer(System::TObject* AWebModuleContext, bool AStripParamQuotes, Httpprod::THandleTagProc AHandleTag, const AnsiString AScriptEngine, Httpprod::_di_ILocateFileService ALocateFileService);
	__fastcall virtual ~TScriptProducer(void);
private:
	void *__IScriptProducer;	/* Httpprod::IScriptProducer */
	
public:
	operator IScriptContext*(void) { return (IScriptContext*)&__IScriptProducer; }
	operator IScriptProducer*(void) { return (IScriptProducer*)&__IScriptProducer; }
	
};


class DELPHICLASS TScriptItems;
class DELPHICLASS TScriptItem;
class PASCALIMPLEMENTATION TScriptItems : public Contnrs::TObjectList 
{
	typedef Contnrs::TObjectList inherited;
	
public:
	TScriptItem* operator[](int Index) { return Items[Index]; }
	
private:
	TScriptProducer* FProducer;
	
public:
	__fastcall TScriptItems(TScriptProducer* AProducer);
	TScriptItem* __fastcall GetScriptItem(int I);
	__property TScriptItem* Items[int Index] = {read=GetScriptItem/*, default*/};
public:
	#pragma option push -w-inl
	/* TList.Destroy */ inline __fastcall virtual ~TScriptItems(void) { }
	#pragma option pop
	
};


class DELPHICLASS TLineNumberMap;
struct TLineNumbers;
typedef TLineNumbers *PLineNumbers;

class PASCALIMPLEMENTATION TLineNumberMap : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	PLineNumbers operator[](int I) { return Items[I]; }
	
private:
	AnsiString FFileName;
	DynamicArray<TLineNumbers >  FArray;
	int __fastcall GetCount(void);
	PLineNumbers __fastcall GetLineNumbers(int I);
	
public:
	PLineNumbers __fastcall New(void);
	int __fastcall DestLineToSourceLine(int ALine, AnsiString &AFileName);
	__property int Count = {read=GetCount, nodefault};
	__property PLineNumbers Items[int I] = {read=GetLineNumbers/*, default*/};
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TLineNumberMap(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TLineNumberMap(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TScriptFile : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Classes::TStream* FSourceStream;
	bool FStreamOwned;
	TScriptProducer* FProducer;
	TScriptItems* FScriptItems;
	AnsiString __fastcall GetScript();
	AnsiString __fastcall GetSource();
	AnsiString __fastcall GetApplicationName();
	AnsiString __fastcall GetLongName();
	AnsiString __fastcall GetShortName();
	int __fastcall GetDestLineCount(void);
	
public:
	TLineNumberMap* FLineNumberMap;
	__fastcall TScriptFile(TScriptProducer* AProducer);
	__fastcall virtual ~TScriptFile(void);
	void __fastcall ParseStream(Classes::TStream* ASource, bool AOwned);
	void __fastcall ParseString(const AnsiString ASource);
	__property AnsiString Script = {read=GetScript};
	__property AnsiString Source = {read=GetSource};
	__property AnsiString ShortName = {read=GetShortName};
	__property AnsiString LongName = {read=GetLongName};
	__property AnsiString ApplicationName = {read=GetApplicationName};
};


#pragma option push -b-
enum TIncludeType { incFile, incPage };
#pragma option pop

class PASCALIMPLEMENTATION TScriptIncludeFile : public TScriptFile 
{
	typedef TScriptFile inherited;
	
private:
	AnsiString FFileName;
	TIncludeType FIncludeType;
	bool FLoaded;
	bool FLoading;
	void __fastcall LoadIncludeFile(void);
	void __fastcall LoadIncludePage(void);
	
public:
	__fastcall TScriptIncludeFile(TScriptProducer* AProducer, TIncludeType AIncludeType, const AnsiString AFileName);
	void __fastcall LoadFile(void);
public:
	#pragma option push -w-inl
	/* TScriptFile.Destroy */ inline __fastcall virtual ~TScriptIncludeFile(void) { }
	#pragma option pop
	
};


class DELPHICLASS TVariableLookup;
class PASCALIMPLEMENTATION TVariableLookup : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Variant FValue;
	AnsiString FIdent;
	System::TObject* FObject;
	System::TObject* FWebModuleContext;
	Classes::TComponent* __fastcall FindFieldVariable(Classes::TComponent* AParent, const AnsiString AName);
	Classes::TComponent* __fastcall FindVariable(const AnsiString AName);
	void __fastcall SetIdent(const AnsiString Value);
	System::TObject* __fastcall GetObject(void);
	
public:
	Classes::TComponent* __fastcall FindGlobalVariable(const AnsiString AName);
	Classes::TComponent* __fastcall FindGlobalVariableContainer(const AnsiString AName);
	__fastcall TVariableLookup(const AnsiString AIdent, System::TObject* AWebModuleContext);
	bool __fastcall LookupObject(void);
	__property AnsiString Ident = {read=FIdent, write=SetIdent};
	__property System::TObject* Obj = {read=GetObject};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TVariableLookup(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION THTMLItem : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	THTMLItems* FItems;
	int FIndex;
	int FOffset;
	int FStreamOffset;
	int FLength;
	bool FTagToken;
	AnsiString __fastcall GetHTML();
	AnsiString __fastcall GetIdent();
	char * __fastcall GetPHTMLChar(void);
	
public:
	__fastcall THTMLItem(THTMLItems* AItems);
	void __fastcall AssignString(int AOffset, char * AHTML, int ALength);
	__property int Offset = {read=FOffset, nodefault};
	__property AnsiString Ident = {read=GetIdent};
	__property AnsiString HTML = {read=GetHTML};
	__property bool TagToken = {read=FTagToken, write=FTagToken, nodefault};
	__property int Length = {read=FLength, nodefault};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~THTMLItem(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TScriptItem : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TScriptItems* FItems;
	
protected:
	virtual AnsiString __fastcall GetScript();
	
public:
	__fastcall TScriptItem(TScriptItems* AItems);
	__property AnsiString Script = {read=GetScript};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TScriptItem(void) { }
	#pragma option pop
	
};


class DELPHICLASS TScriptCodeItem;
class PASCALIMPLEMENTATION TScriptCodeItem : public TScriptItem 
{
	typedef TScriptItem inherited;
	
private:
	AnsiString FScript;
	
protected:
	virtual AnsiString __fastcall GetScript();
	
public:
	void __fastcall AssignString(const AnsiString AValue);
public:
	#pragma option push -w-inl
	/* TScriptItem.Create */ inline __fastcall TScriptCodeItem(TScriptItems* AItems) : TScriptItem(AItems) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TScriptCodeItem(void) { }
	#pragma option pop
	
};


class DELPHICLASS TScriptIncludeItem;
class PASCALIMPLEMENTATION TScriptIncludeItem : public TScriptItem 
{
	typedef TScriptItem inherited;
	
private:
	TScriptIncludeFile* FScriptIncludeFile;
	
protected:
	virtual AnsiString __fastcall GetScript();
	
public:
	__fastcall TScriptIncludeItem(TScriptItems* AItems, TScriptIncludeFile* AIncludeFile);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TScriptIncludeItem(void) { }
	#pragma option pop
	
};


#pragma option push -b-
enum TGlobalScriptVariables { svPage, svPages, svModules, svApplication, svSession, svEndUser, svResponse, svRequest, svHTMLItems, svProducer };
#pragma option pop

class DELPHICLASS TAbstractScriptObjectFactory;
class DELPHICLASS TAbstractScriptEngine;
class DELPHICLASS TScriptGlobalObjects;
class PASCALIMPLEMENTATION TAbstractScriptObjectFactory : public System::TObject 
{
	typedef System::TObject inherited;
	
protected:
	virtual TAbstractScriptEngine* __fastcall GetScriptEngine(void) = 0 ;
	virtual System::_di_IInterface __fastcall CreateComponentObject(System::TObject* AComponent, TMetaClass* AClassKey) = 0 ;
	virtual void __fastcall AddGlobalObjects(TScriptGlobalObjects* AScriptGlobalObjects);
	virtual System::_di_IInterface __fastcall CreateProducerObject(TGlobalScriptVariables AVariable, Httpprod::_di_IScriptProducer AProducer) = 0 ;
	
public:
	virtual System::_di_IInterface __fastcall CreateGlobalObject(TGlobalScriptVariables AVariable, Httpprod::_di_IScriptContext AContext) = 0 ;
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TAbstractScriptObjectFactory(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TAbstractScriptObjectFactory(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TScriptGlobalObjects : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Classes::_di_IInterfaceList FIntfList;
	Classes::TStrings* FNamedList;
	Httpprod::_di_IScriptProducer FProducer;
	
protected:
	virtual TAbstractScriptEngine* __fastcall GetScriptEngine(void) = 0 ;
	
public:
	__fastcall TScriptGlobalObjects(Httpprod::_di_IScriptProducer AProducer);
	int __fastcall GetNamedItemCount(void);
	AnsiString __fastcall GetNamedItemName(int I);
	void __fastcall AddNamedIntf(const AnsiString AName, System::_di_IInterface AIntf);
	System::_di_IInterface __fastcall FindNamedItemIntf(const AnsiString AName);
	__fastcall virtual ~TScriptGlobalObjects(void);
	__property int NamedItemCount = {read=GetNamedItemCount, nodefault};
	__property AnsiString NamedItemName[int I] = {read=GetNamedItemName};
	__property Httpprod::_di_IScriptProducer Producer = {read=FProducer};
	__property TAbstractScriptEngine* ScriptEngine = {read=GetScriptEngine};
};


class DELPHICLASS TScriptErrors;
class PASCALIMPLEMENTATION TScriptErrors : public Httpprod::TAbstractScriptErrors 
{
	typedef Httpprod::TAbstractScriptErrors inherited;
	
private:
	Contnrs::TObjectList* FList;
	
protected:
	virtual Httpprod::TAbstractScriptError* __fastcall GetError(int I);
	virtual int __fastcall GetErrorCount(void);
	
public:
	__fastcall TScriptErrors(void);
	__fastcall virtual ~TScriptErrors(void);
	virtual void __fastcall Add(const Httpprod::TAbstractScriptError* AError);
};


class DELPHICLASS TScriptError;
class PASCALIMPLEMENTATION TScriptError : public Httpprod::TAbstractScriptError 
{
	typedef Httpprod::TAbstractScriptError inherited;
	
protected:
	int FLine;
	int FCharPos;
	AnsiString FDescription;
	AnsiString FSourceLine;
	AnsiString FFileName;
	virtual AnsiString __fastcall GetSourceLine();
	virtual int __fastcall GetCharPos(void);
	virtual int __fastcall GetLine(void);
	virtual AnsiString __fastcall GetDescription();
	virtual void __fastcall SetDescription(const AnsiString AValue);
	virtual AnsiString __fastcall GetFileName();
	
public:
	__fastcall TScriptError(Sysutils::Exception* E)/* overload */;
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TScriptError(void) { }
	#pragma option pop
	
};


class DELPHICLASS TCurrentWebPageInfo;
class PASCALIMPLEMENTATION TCurrentWebPageInfo : public System::TInterfacedObject 
{
	typedef System::TInterfacedObject inherited;
	
private:
	Httpprod::_di_IScriptContext FContext;
	Webcntxt::_di_IWebPageInfo FWebPageInfo;
	
protected:
	Webcntxt::_di_IWebPageInfo __fastcall WebPageInfo();
	AnsiString __fastcall GetPageName();
	AnsiString __fastcall GetPageHREF();
	AnsiString __fastcall GetPageDescription();
	AnsiString __fastcall GetPageTitle();
	bool __fastcall GetPageIsPublished(void);
	bool __fastcall GetLoginRequired(void);
	bool __fastcall GetHasViewAccess(void);
	
public:
	__fastcall TCurrentWebPageInfo(Httpprod::_di_IScriptContext AContext);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TCurrentWebPageInfo(void) { }
	#pragma option pop
	
private:
	void *__IWebPageInfo;	/* Webcntxt::IWebPageInfo */
	
public:
	operator IWebPageInfo*(void) { return (IWebPageInfo*)&__IWebPageInfo; }
	
};


struct TLineNumbers
{
	
public:
	int SourceStartLine;
	int SourceLineCount;
	int DestStartLine;
	int DestLineCount;
	TScriptIncludeFile* ScriptIncludeFile;
} ;

typedef DynamicArray<TLineNumbers >  WebScript__02;

class DELPHICLASS TAbstractScriptObjectFactories;
class PASCALIMPLEMENTATION TAbstractScriptObjectFactories : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	TAbstractScriptObjectFactory* operator[](int I) { return Factories[I]; }
	
protected:
	virtual int __fastcall GetCount(void) = 0 ;
	virtual TAbstractScriptObjectFactory* __fastcall GetFactory(int I) = 0 ;
	virtual Contnrs::TObjectList* __fastcall GetObjectList(void) = 0 ;
	
public:
	__property int Count = {read=GetCount, nodefault};
	__property TAbstractScriptObjectFactory* Factories[int I] = {read=GetFactory/*, default*/};
	__property Contnrs::TObjectList* ObjectList = {read=GetObjectList};
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TAbstractScriptObjectFactories(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TAbstractScriptObjectFactories(void) { }
	#pragma option pop
	
};


class DELPHICLASS TScriptObjectFactories;
class PASCALIMPLEMENTATION TScriptObjectFactories : public TAbstractScriptObjectFactories 
{
	typedef TAbstractScriptObjectFactories inherited;
	
public:
	TAbstractScriptObjectFactory* operator[](int I) { return Factories[I]; }
	
private:
	Contnrs::TObjectList* FObjectList;
	
protected:
	virtual int __fastcall GetCount(void);
	virtual TAbstractScriptObjectFactory* __fastcall GetFactory(int I);
	virtual Contnrs::TObjectList* __fastcall GetObjectList(void);
	
public:
	__fastcall TScriptObjectFactories(void);
	__fastcall virtual ~TScriptObjectFactories(void);
	System::_di_IInterface __fastcall CreateGlobalObject(TGlobalScriptVariables AVariable, Httpprod::_di_IScriptContext AContext);
	__property int Count = {read=GetCount, nodefault};
	__property TAbstractScriptObjectFactory* Factories[int I] = {read=GetFactory/*, default*/};
};


typedef System::_di_IInterface __fastcall (*CreateComponentStubFactory)(System::TObject* AComponent, TMetaClass* AComponentClass);

class DELPHICLASS TScriptEnginesList;
class PASCALIMPLEMENTATION TScriptEnginesList : public Httpprod::TAbstractScriptEnginesList 
{
	typedef Httpprod::TAbstractScriptEnginesList inherited;
	
private:
	Contnrs::TObjectList* FList;
	int __fastcall GetCount(void);
	TAbstractScriptEngine* __fastcall GetItem(int I);
	
public:
	__fastcall TScriptEnginesList(void);
	__fastcall virtual ~TScriptEnginesList(void);
	virtual TMetaClass* __fastcall FindScriptProducerClass(const AnsiString ALanguageName);
	TAbstractScriptEngine* __fastcall Find(const AnsiString AName);
	void __fastcall AddObjectFactory(TAbstractScriptObjectFactory* AFactory, const AnsiString AEngineName);
	void __fastcall AddEngine(TAbstractScriptEngine* AEngine);
	void __fastcall RemoveEngine(TAbstractScriptEngine* AEngine);
	void __fastcall ListLanguageNames(Classes::TStrings* AList);
	__property int Count = {read=GetCount, nodefault};
	__property TAbstractScriptEngine* Items[int I] = {read=GetItem};
};


class PASCALIMPLEMENTATION TAbstractScriptEngine : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	AnsiString FName;
	TMetaClass* FScriptProducerClass;
	TAbstractScriptObjectFactories* FScriptObjectFactories;
	
public:
	virtual void __fastcall ListLanguageNames(Classes::TStrings* AList) = 0 ;
	virtual bool __fastcall SupportsLanguage(const AnsiString AName) = 0 ;
	__fastcall TAbstractScriptEngine(const AnsiString AName);
	__fastcall virtual ~TAbstractScriptEngine(void);
	System::_di_IInterface __fastcall CreateComponentStub(System::TObject* AObject);
	void __fastcall AddObjectFactory(TAbstractScriptObjectFactory* AFactory);
	__property AnsiString Name = {read=FName};
	__property TAbstractScriptObjectFactories* ScriptObjectFactories = {read=FScriptObjectFactories};
	__property TMetaClass* ScriptProducerClass = {read=FScriptProducerClass, write=FScriptProducerClass};
};


//-- var, const, procedure ---------------------------------------------------
extern PACKAGE char *GlobalScriptVariableNames[10];

}	/* namespace Webscript */
using namespace Webscript;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Webscript
